# PDF-O-Matic is copyright (c) 2009, Brett Neumeier.
#
# PDF-O-Matic may be used under the terms of the GPL.  See
# COPYING.GPL, provided in this distribution, for full details.
#
# DOJ and CompNet Design, Inc., are granted a perpetual license to
# use, extend, modify, and redistribute the PDF-O-Matic software as
# they wish, without restriction.

require 'pdf_helpers'
require 'item_box'

class PowerBox < ItemBox

  class PowerItem < ItemBoxItem
    attr_reader :cost, :endcost, :name
    def initialize(pdf, item)
      super(pdf, item)

      @cost = item['cost'] || ''
      @endcost = item['end_cost'] || ''
      @endcost = '' if @endcost == 0
      @name = item['name'] || ''

      if item['list'] && !item['framework']
        @cost = ''
        @name = item['alias']
        t = item['text'].gsub("#{@name}, ",'')
      else
        t = item['text'] || ''
        t.gsub!(/Active Points/, 'APs')
        t.gsub!(/ ?\(?Real Cost: [0-9]*\)/, '')
        t.gsub!(/ ,/, ',')
        t = item['prefix'] + ' ' + t if item['prefix']
      end
      @text = cleanup_string(t)
    end
  end

  def add_all(character)
    slots = []
    [ 'powers', 'equipment' ].each { |category|
      if Enumerable === character[category]
        slots << { 'separator' => true } unless slots.empty?
        slots << character[category]
      end
    }
    slots.flatten!
    slots.each { |item| 
      if item['separator']
        items << SeparatorItem.new
      else
        items << PowerItem.new(pdf, item)
      end
    }
    self
  end

  def contents
    'power'
  end

end
